CREATE FUNCTION CF_Seg_User_Validar (@Id_Usuario SMALLINT,@Equate VARCHAR(30) )
RETURNS TINYINT
AS

BEGIN
DECLARE @Retorno TINYINT
		,@DoorNo  SMALLINT
		,@DenyFlag TINYINT

SET @DoorNo = ISNULL((SELECT TOP 1 [No] FROM Seg_Door WHERE Equate = @Equate),'')

IF (@DoorNo = '')
	RETURN 0

--busco negacion individual
SET @DenyFlag = (SELECT DenyFlag FROM Seg_Access WHERE DenyFlag = 1 AND DoorNo = @DoorNo AND UserNo = @Id_Usuario)
IF (@DenyFlag = 1)   --Si existe NO tiene permismo
	RETURN 0

--busco aprobacion individual
SET @DenyFlag = (SELECT DenyFlag FROM Seg_Access WHERE DenyFlag = 0 AND DoorNo = @DoorNo AND UserNo = @Id_Usuario)
IF (@DenyFlag = 0)   --Si existe tiene permismo
	RETURN 1

--busco negacion por grupo
SET @DenyFlag = (SELECT DenyFlag FROM Seg_Access WHERE DenyFlag = 1 AND DoorNo = @DoorNo 
						AND UserNo IN (SELECT UGrpNo FROM Seg_UserInGroup WHERE UserNo = @Id_Usuario)
				)
IF (@DenyFlag = 1)   --Si existe NO tiene permismo
	RETURN 0

--busco aprobacion por grupo
SET @DenyFlag = (SELECT DenyFlag FROM Seg_Access WHERE DenyFlag = 0 AND DoorNo = @DoorNo 
						AND UserNo IN (SELECT UGrpNo FROM Seg_UserInGroup WHERE UserNo = @Id_Usuario)
				)
IF (@DenyFlag = 0)   --Si existe NO tiene permismo
	RETURN 1


RETURN 0

END
GO

